package com.androidbook.simpletelephony;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.telephony.PhoneNumberUtils;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.widget.EditText;

public class CheckStatusActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO Auto-generated method stub
        super.onCreate(savedInstanceState);
        
        TelephonyManager telManager = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
        String opName = telManager.getNetworkOperatorName();
        Log.i("Telefonia", "Nazwa operatora = " + opName);
        
        String phoneNumber = telManager.getLine1Number();
        Log.i("Telefonia", "Numer telefonu = " + phoneNumber);
        
        String providerName = telManager.getSimOperatorName();
        Log.i("Telefonia", "Nazwa dostawcy = " + providerName);
        
        int callStatus = telManager.getCallState();
        String callState = getCallStateString(callStatus);
        Log.i("Telefonia", callState);
        
        telManager.listen(new PhoneStateListener() {
            public void onCallStateChanged(int state, String incomingNumber) {
                String newState = getCallStateString(state);
                if (state == TelephonyManager.CALL_STATE_RINGING) {
                    Log.i("Telefonia", newState + " numer = " + incomingNumber);
                } else {
                    Log.i("Telefonia", newState);
                }
                    
            }
            
        }, PhoneStateListener.LISTEN_CALL_STATE);
        
        ServiceState serviceState = new ServiceState();
        int serviceStatus = serviceState.getState();
        String serviceStateString = getServiceStateString(serviceStatus);
        Log.i("Telefonia", serviceStateString);
        
        
        boolean isRoaming = serviceState.getRoaming();
        Log.i("Telefonia", "Stan roamingu " + isRoaming);
        
        
        String formattedNumber = PhoneNumberUtils.formatNumber("9995551212");
        Log.i("Telefonia", formattedNumber);
        
        setContentView(R.layout.status);
        EditText numberEntry = (EditText) findViewById(R.id.number_entry);
        numberEntry.addTextChangedListener(new PhoneNumberFormattingTextWatcher());
        
    }
    
    private String getCallStateString(int callState)    {
        String callStateString = null;
        switch (callState) {
            case TelephonyManager.CALL_STATE_IDLE:
                callStateString = "Telefon nie jest używany.";
                break;
            case TelephonyManager.CALL_STATE_OFFHOOK:
                callStateString = "Telefon jest używany.";
                break;
            case TelephonyManager.CALL_STATE_RINGING:
                callStateString = "Telefon dzwoni!";
                break;
        }
        
        return callStateString;
    }
    
    private String getServiceStateString(int serviceState) {
        String serviceStateString = null;
        switch (serviceState) {
            case ServiceState.STATE_EMERGENCY_ONLY:
                serviceStateString = "Tylko połączenia alarmowe";
                break;
            case ServiceState.STATE_IN_SERVICE:
                serviceStateString = "Normalne usługi";
                break;
            case ServiceState.STATE_OUT_OF_SERVICE:
                serviceStateString = "Brak dostępnych usług";
                break;
            case ServiceState.STATE_POWER_OFF:
                serviceStateString = "Nadajnik telefonu jest wyłączony";
                break;
        }
        
        return serviceStateString;
        
    }

}
